<?php
// ___________________________________________________________
//| vB.Sponsors - vBSponsors.php 							  |
//| Written by: Justin Doles - www.DigitalDeviation.com 	  |
//| Extension Version: 2.0.5								  |
//| vBulletin Version: 3.6.x    							  |
//| ----------------------------------------------------------|
//| Description: Allows the addition of sponsors to 		  |
//| forums and/or categories.  Tracks hits for each sponsor.  |
//| ----------------------------------------------------------|
//| License: This vBulletin extension is provided as-is with  |
//| no warranty implied or stated.  No part of this code may  |
//| be reproduced or distributed, in part or in whole, without|
//| written consent of the author.                            |
//| You may NOT remove the branding (vB.Sponsors) from the    |
//| footer of your site.                                      |
//|___________________________________________________________|
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);
define('THIS_SCRIPT', 'vBSponsors');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cphome', 'forum');
$specialtemplates = array('');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');

print_cp_header($vbphrase['sponsor_cp_title'], '', '', 0, '');
 // ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminsettings'))
{
    print_cp_no_permission();
}
	//Clean do
	$vbulletin->input->clean_gpc('r', 'do', TYPE_STR);

	if ($vbulletin->GPC['do'] == 'statistics') {
		print_form_header('vBSponsors', 'statistics_view', false, false, 'vBSponsors_statistics', '90%', '', false, 'post');
		print_table_start();
		print_table_header($vbphrase['sponsor_cp_title']);
		print_table_header($vbphrase['sponsor_cp_statistics']);
		print_chooser_row($vbphrase['sponsor_cp_statistics_choose_forum'], "forumid", "forum", "title", '', 0, 'WHERE sponsor_enabled = 1 AND CHAR_LENGTH(sponsor_name) > 0');
		print_submit_row(' '); 
		print_table_footer(2, '', '', 0);
	}	

	if ($vbulletin->GPC['do'] == 'statistics_view') {
		$vbulletin->input->clean_gpc('p', 'forumid', TYPE_INT);
		$sql = "SELECT title, sponsor_name, sponsor_url, FROM_UNIXTIME(sponsor_date_updated, '%m-%d-%Y') as fsponsor_date_updated FROM " . TABLE_PREFIX . "forum WHERE forumid = '" . $vbulletin->GPC['forumid'] ."' ORDER BY fsponsor_date_updated";
		$forum_info = $db->query_first($sql);
		print_table_start();
		print_table_header($vbphrase['sponsor_cp_title']);
		print_table_header($vbphrase['sponsor_cp_statistics_statistics_for'] . $forum_info['title']);
		//sponsor name
		$arrCells = array(0 => "<strong>" . $vbphrase['sponsor_name'] . "</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . stripslashes($forum_info['sponsor_name']));
		print_cells_row($arrCells);
		//sponsor link
		$arrCells = array(0 => "<strong>" . $vbphrase['sponsor_cp_statistics_sponsor_link'] . "</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . $forum_info['sponsor_url']);
		print_cells_row($arrCells);
		//sponsor updated
		$arrCells = array(0 => "<strong>" . $vbphrase['sponsor_cp_statistics_sponsor_date_updated'] . "</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . $forum_info['fsponsor_date_updated']);
		print_cells_row($arrCells);
		print_hr_row();
		$arrCells = "";
		//free results
		$db->free_result($forum_info);
		//get sponsor hits
		$sql = "SELECT COUNT(*) AS hits, FROM_UNIXTIME(date, '%m-%d-%Y') AS fdate FROM " . TABLE_PREFIX . "vbsponsors WHERE forum_id = '" . $vbulletin->GPC['forumid'] ."' GROUP BY fdate";
		$sponsor_stats = $db->query_read($sql);
		if ($db->num_rows($sponsor_stats) > 0) {
			$arrCells = array(0 => "<strong></strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong></strong>");
			print_cells_row($arrCells);
			while($sponsor_stat = $db->fetch_array($sponsor_stats)) {
				$arrCells = array(0 => $sponsor_stat['fdate'] . "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . $sponsor_stat['hits']);
				print_cells_row($arrCells);
			}
			$arrCells = "";			
		}
		else {
			print_description_row($vbphrase['sponsor_cp_statistics_none']);
		}
		print_hr_row();
		print_description_row($vbphrase['sponsor_cp_statistics_current_as_of'] . date("m-d-Y"));
		//free results
		$db->free_result($sponsor_stats);
		print_table_footer(2, '', '', 0);
	}	
//close up the cp page	
print_cp_footer();

?>